<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Meal extends Model 
{

    protected $table = 'meals';
    public $timestamps = true;
    protected $fillable = array('name', 'description', 'price', 'offer_price', 'processing_time');

    public function restaurants()
    {
        return $this->belongsToMany('App\Models\Restaurant');
    }

    public function order()
    {
        return $this->belongsTo('App\Models\Order');
    }

}